<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.OpenQuestionSelection" Title="<%$ Resources:Resource, VoxcoReporting%>" Theme="Voxco" Codebehind="OpenQuestionSelection.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
	<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">		
		<script type="text/javascript">
	    
			function InputKeyUp(_buttonId, evt)
			{
				if (13 == evt.keyCode) 
				{
					__doPostBack(_buttonId,'')
				}
			}
	        
		</script>
    </telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="OpenQuestionsDataSource" runat="server" SelectMethod="GetGenericAvailableOpen"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedOpenDataSource" runat="server" SelectMethod="GetGenericSelectedOpen"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>

    <telerik:RadAjaxPanel ID="VariablesRadAjaxPanel" runat="server" Height="350px" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="RadAjaxPanel_OnAjaxRequest" CssClass="mainContent">
        <br />
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
            <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
        </telerik:RadAjaxLoadingPanel>
                    
		<div style="float: left; width: 45%;">			
                    
			<asp:Label ID="Panel2" runat="server" Text="<%$ Resources:Resource, OpenQuestions%>" CssClass="title" />
                    
            <div>
				<asp:TextBox ID="FindVariableTxt" runat="server"  Width="150px" ></asp:TextBox> 
                <asp:ImageButton ID="FindVariableBt" runat="server" ImageUrl="~/icons/ico16_find.gif" OnClick="FindVariable_Click" ToolTip="<%$ Resources:Resource, Find%>" />
                <asp:ImageButton ID="ClearVariableBt" runat="server" ImageUrl="~/icons/cancel.gif" OnClick="ResetVariable_Click" ToolTip="<%$ Resources:Resource, Clear%>" />
			</div>
			
			<telerik:RadGrid ID="grdOpenQuestions" runat="server" AllowMultiRowSelection="True" AutoGenerateColumns="False"
                DataSourceID="OpenQuestionsDataSource" EnableViewState="true" OnDataBound="grdOpenQuestions_DataBound"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
                <MasterTableView GroupLoadMode="Client" DataSourceID="OpenQuestionsDataSource"  NoDetailRecordsText="" NoMasterRecordsText="" Width="100%">
                    <Columns>
                        <telerik:GridClientSelectColumn UniqueName="Selected">
							<HeaderStyle Width="10%" HorizontalAlign="Left" />
							<ItemStyle Width="10%" HorizontalAlign="Left" />
                        </telerik:GridClientSelectColumn>
                        <telerik:GridBoundColumn DataField="Alias" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">
							<HeaderStyle Width="90%" HorizontalAlign="left" />
							<ItemStyle Width="90%" HorizontalAlign="left" />
                        </telerik:GridBoundColumn>
                        <telerik:GridBoundColumn DataField="ChoiceCount" UniqueName="ChoiceCount" Visible="true" Display="false">
                        </telerik:GridBoundColumn>
                    </Columns>
                </MasterTableView>
                <ClientSettings AllowGroupExpandCollapse="True">
                    <Selecting AllowRowSelect="True" />
                    <Scrolling AllowScroll="True" UseStaticHeaders="True" />
                </ClientSettings>                            
            </telerik:RadGrid>		             
                
        </div>
        
        <div style="float: left; width: 25px; height: 100%;">            
			<div class="arrows">
				<asp:ImageButton ID="btnAddRows" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddOpen_Click" /><br />
				<asp:ImageButton ID="btnRemoveRows" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveOpen_Click" />
            </div>            
		</div>
        
        <div style="float: left; width: 45%;">          
               
			<asp:Label ID="Panel1" runat="server" Text="<%$ Resources:Resource, SelectedQuestions%>" CssClass="title" />
					
			<div>
				<asp:TextBox ID="FindSelectedVariableTxt" runat="server"  Width="150px" ></asp:TextBox> 
				<asp:ImageButton ID="FindSelectedVariableBt" runat="server" ImageUrl="~/icons/ico16_find.gif" OnClick="FindVariable_Click" ToolTip="<%$ Resources:Resource, Find%>" />
				<asp:ImageButton ID="FindSelectedVariableClr" runat="server" ImageUrl="~/icons/cancel.gif" OnClick="ResetVariable_Click" ToolTip="<%$ Resources:Resource, Clear%>" />
			</div>
			
			<telerik:RadGrid ID="gridSelectedOpen" runat="server" AllowMultiRowSelection="True" AutoGenerateColumns="False"
			DataSourceID="SelectedOpenDataSource" EnableViewState="true" OnDataBound="grd_DataBound" 
			EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
				<MasterTableView GroupLoadMode="Client" DataSourceID="SelectedOpenDataSource" NoDetailRecordsText="" NoMasterRecordsText="" Width="100%">
					<Columns>
						<telerik:GridClientSelectColumn UniqueName="Selected">
							<HeaderStyle Width="10%" HorizontalAlign="left" />
							<ItemStyle Width="10%" HorizontalAlign="Left"/>
						</telerik:GridClientSelectColumn>
						<telerik:GridBoundColumn DataField="Alias" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">
							<HeaderStyle Width="90%" HorizontalAlign="left" />
							<ItemStyle Width="90%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="Invalid" UniqueName="Invalid" Display="false">
						</telerik:GridBoundColumn>
					</Columns>
				</MasterTableView>
				<ClientSettings AllowGroupExpandCollapse="True">
					<Selecting AllowRowSelect="True" />
					<Scrolling AllowScroll="True" UseStaticHeaders="True" />
				</ClientSettings>
				<ItemStyle Height="15px" Width="100%" />
				<SelectedItemStyle Width="100%" />
				<HeaderStyle Width="100%" Wrap="True" />
				<PagerStyle AlwaysVisible="True" BorderColor="Black" BorderStyle="Solid" BorderWidth="1px" PageButtonCount="50" />
			</telerik:RadGrid>
                        					                			
		</div>		

	</telerik:RadAjaxPanel>

</asp:Content>
